/*
 * $QNXLicenseC:
 * Copyright 2012, 2013, 2014 QNX Software Systems. All Rights Reserved.
 *
 * You must obtain a written license from and pay applicable
 * license fees to QNX Software Systems before you may reproduce,
 * modify or distribute this software, or any work that includes
 * all or part of this software.   Free development licenses are
 * available for evaluation and non-commercial purposes.  For more
 * information visit http://licensing.qnx.com or email
 * licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review
 * this entire file for other proprietary rights or license notices,
 * as well as the QNX Devcypresspment Suite License Guide at
 * http://licensing.qnx.com/license-guide/ for other information.
 * $
 */

#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <sys/mman.h>
#include <stdint.h>
#include "cypress_i2c.h"
#include "platform.h"
#include "touch.h"

#ifndef UNITTEST
#include <hw/inout.h>
#include "i2c_client.h"
#include "input/mtouch_log.h"
#else
#include <errno.h>
#endif

/*
 * (cypress on sa8155 board)
 */

void
cypress_platform_tp_fini(cypress_dev_t* dev)
{
	return;
}

/**
 * Responsible for populating the dev->platform.data
 */

int
cypress_platform_tp_init(cypress_dev_t* dev)
{
	/* In GMVCU display, there is no synchronisation between display and touch driver.
        During startup of display, display driver reset the  power cycle of display around 6s of boottime.
	At the same time, touch driver is getting loaded and sporadically device runs into unknown state
        because of power failure to the touch chip. It is advised to delay the driver for few seconds as
        a workaround solution until a proper synchronisation between display and touch driver are achieved */

	if (0 < dev->delay_driver)
                delay(dev->delay_driver * 1000);

	return 0;
}

int
cypress_platform_tp_msg_pending(cypress_dev_t* dev) {
	return 1;
}

int
cypress_platform_check(cypress_dev_t* dev)
{
	return 0;
}

int
cypress_platform_tp_reset(cypress_dev_t* dev)
{
    uint8_t  ret, len = 2;
    uint8_t buf[2] = {0};
    int fd, Ctrl_handle, RetVal = 0;

    Ctrl_handle = displaybinder_ctrl_open(dev->dev_ctrl_path);  // dev_control_path -> dev/vcd/display-binder/control
    if(Ctrl_handle == -1)
    {
        mtouch_error(dev->log_name, "Error to open display binder control path");
    } else {
       RetVal = displaybinder_ctrl_set(Ctrl_handle, "touch-reset","one-time");
       if(RetVal < 0)
       {
           mtouch_error(dev->log_name, "Failed to reset the touch controller through FIDM API %d", RetVal);
           displaybinder_ctrl_close(Ctrl_handle);
       } else {
             mtouch_info(dev->log_name, "executed touch reset successfully through FIDM API\n");
             displaybinder_ctrl_close(Ctrl_handle);
             return RetVal;
       }
    }
    if((Ctrl_handle == -1) || (RetVal < 0))
    {
        fd = i2c_open(dev->i2c_dev_name);
        if (fd == -1)
            return -ENODEV;

        if((i2c_set_slave_addr(fd, 0x12, I2C_ADDRFMT_7BIT)) == -1) {
            mtouch_error(dev->log_name, "Fail to set mcu slave address %s", dev->i2c_dev_name);
            i2c_close(fd);
            return -1;
        }

        if((i2c_set_bus_speed(fd, I2C_SPEED_HIGH, &dev->i2c_speed)) == -1) {
            mtouch_debug(dev->log_name, "Failed to set i2c speed for mcu, default speed will be set"); /* default speed is set,even on failure */
        }

        buf[0] = 0x31;
        buf[1] = 0x01;

        ret = i2c_write(fd, buf, len);
        i2c_close(fd);

        if(ret == len) {
            return 0;
        }
    }

    return -1;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/nto/arm/so.le.v7.imx6/imx6.c $ $Rev: 798438 $")
#endif
